/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.handler.data.IQuestCategory;
import noppes.npcs.controllers.data.Quest;

public class QuestCategory
implements IQuestCategory {
    public final TreeMap<Integer, Quest> quests = new TreeMap();
    public int id = -1;
    public String title = "";

    @Override
    public IQuest create() {
        return new Quest(this);
    }

    @Override
    public String getName() {
        return new TextComponentTranslation(this.title, new Object[0]).func_150254_d();
    }

    @Override
    public IQuest[] quests() {
        return this.quests.values().toArray(new IQuest[0]);
    }

    public void load(NBTTagCompound nbttagcompound) {
        this.id = nbttagcompound.func_74762_e("Slot");
        this.title = nbttagcompound.func_74779_i("Title");
        NBTTagList dialogsList = nbttagcompound.func_150295_c("Dialogs", 10);
        for (int ii = 0; ii < dialogsList.func_74745_c(); ++ii) {
            NBTTagCompound compound = dialogsList.func_150305_b(ii);
            Quest quest = new Quest(this);
            quest.load(compound);
            this.quests.put(quest.id, quest);
        }
    }

    public NBTTagCompound save(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("Slot", this.id);
        nbttagcompound.func_74778_a("Title", this.title);
        NBTTagList dialogs = new NBTTagList();
        for (int dialogId : this.quests.keySet()) {
            Quest quest = this.quests.get(dialogId);
            dialogs.func_74742_a((NBTBase)quest.save(new NBTTagCompound()));
        }
        nbttagcompound.func_74782_a("Dialogs", (NBTBase)dialogs);
        return nbttagcompound;
    }

    public QuestCategory copy() {
        QuestCategory newCat = new QuestCategory();
        newCat.load(this.save(new NBTTagCompound()));
        return newCat;
    }
}

